dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 4, 270, 250, "assets/images/table/redtable", "assets/images/food/item_mark3", "R" );
LManager:AddNewTable( 2, 2, 185, 400, "assets/images/table/redtable_2", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 3, 365, 400, "assets/images/table/redtable", "assets/images/food/item_mark1", "R" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 0;
numServers = 1;
maxCoupleHappiness = 250;

-- Group 1

guest = LManager.GenGuest(male04);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = male04;
guest.percentRequestTissue = 40;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 3000);

-- Group 2

guest = LManager.GenGuest(female03);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = table2;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(5, 6, 22000);


-- Group 3


guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female04;
guest.percentRequestTissue = 40;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(7, 9, 36000);


-- Group 4


guest = LManager.GenGuest(male01);
guest.matchType = table2;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(10, 10, 58000);


-- Group 5

guest = LManager.GenGuest(female03);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female03;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = aunt;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(11, 14, 90000);

-- Group 6

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(15, 16, 120000);


LManager:AdjustGuestTolerance(150);

LManager:SetLevelSetting ("bridesmaidsDelay", 60000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

-- Custom event - effects path, x, y, delay
LManager:AddQuinnEvent( "fx/fx_bees.lua", 600, 300, 80000 );
LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 100000 );

-- Set up the Level Settings
LManager:SetLevelNumber(1,10);
LManager:SetLevelScores(6300, 9200);
LManager:SetLevelTime(300000);
LManager:SetLevelSetting ("blaster", 0);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/Dance Dance 1.ogg","assets/audio/music/new_dance_1.ogg");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );